package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class Source.
 * 
 * Description: In this Source Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "Source", schema = "dbo")
public class Source implements Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 5135875868724790783L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;
	
	/** The description. */
	@Column(name = "Description", length = 50)
	private String description;
	
	/** The Requests */
	@OneToMany(fetch=FetchType.LAZY, mappedBy="source")
	private Set<Request> requests = new HashSet<>(0);

	/**
	 * Gets the id.
	 *
	 * @return the source id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the source id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the description.
	 *
	 * @return the source description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the source description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	
	/** Gets request
	 * @return  Returns Request associated with the source
	 */
    public Set<Request> getRequests() {
        return this.requests;
    }
    
	/**
	 * Sets the requests
	 *
	 * @param requests the requests
	 * 
	  */
    public void setRequests(Set<Request> requests) {
        this.requests = requests;
    }
}
